<?php
$PageName = "Pragmatic Play";
$PageFileName = "pragmatic-play";

include "template/config.php" ?>
<!DOCTYPE html>
<html lang="<?php echo $Lang ?>">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo ''. $BrandName .': '. $Title . ' ' . $PageName .'' ?></title>
    <meta name="description" content="<?php echo $MetaDescription ?>">
    <link rel="shortcut icon" href="<?php echo $Favicon ?>?ver=<?php echo $Version ?>" type="image/x-icon">
    <link rel="canonical" href="<?php echo $Canonical ?>">
    <meta name="keywords" content="<?php echo $Keyword ?>">
    <meta name="robots" content="<?php echo $Robots ?>">
    <meta name="google-site-verification" content="<?php echo $GSV ?>">
    <!-- Facebook Meta Tags -->
    <meta property="og:url" content="<?php echo $OpenGraphURL ?>">
    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo $OpenGraphTitle ?>">
    <meta property="og:description" content="<?php echo $OpenGraphDescription ?>">
    <meta property="og:image" content="<?php echo $OpenGraphImage ?>">
    <!-- Twitter Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta property="twitter:domain" content="<?php echo $DomainName ?>">
    <meta property="twitter:url" content="<?php echo $OpenGraphURL ?>">
    <meta name="twitter:title" content="<?php echo $OpenGraphTitle ?>">
    <meta name="twitter:description" content="<?php echo $OpenGraphDescription ?>">
    <meta name="twitter:image" content="<?php echo $OpenGraphImage ?>">
    <!-- Stylings Script -->
    <link rel="stylesheet" href="assets/css/style.css?ver=<?php echo $Version ?>">
    <script src="assets/js/lib/jquery.js?ver=<?php echo $Version ?>"></script>
    <script src="assets/js/lib/popper.js?ver=<?php echo $Version ?>"></script>
    <!-- Preload -->
    <link rel="preload" href="<?php echo $DesktopBanner ?>" as="image"/>
    <link rel="preload" href="<?php echo $MobileBanner ?>" as="image"/>
    <?php include "template/systems/colors.php" ?>
</head>
<body>
    <header>
        <div class="top-header">
            <div class="wrapper">
                <div class="logo">
                    <a href="/">
                        <?php echo '<img src="'. $LogoImage .'?ver='. $Version .'" alt="'. $BrandName .'" title="'. $BrandName .'">' ?>
                    </a>
                </div>
                <div class="date">
                    <div class="date-wrap">
                        <?php include  "template/systems/date.php" ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="banner">
            <div class="wrapper">
                <?php include "template/parts/banner.php" ?>
            </div>
        </div>
        <div class="bottom-header">
            <div class="wrapper">
                <div class="broadcast">
                    <marquee behavior="scroll" direction="left"><?php echo $Broadcast ?></marquee>
                </div>
                <div class="button">
                    <a href="<?php echo $Linklogin ?>" target="_blank" title="Masuk">Masuk</a>
                    <a href="<?php echo $LinkRegister ?>" target="_blank" title="Daftar">Daftar</a>
                </div>
            </div>
        </div>
    </header>
    <main>
        <div class="wrapper">
            <div class="sidebar">
            <ul>
                <?php include "template/parts/sidebar.php" ?>
            </ul>
        </div>
        <div class="container">
            <div class="container-content">
                <div class="container-search">
                    <input type="text" id="SearchGames" placeholder="Cari Games..." title="Ketik Disini">
                </div>
                <div class="container-games" id="list-games">
                    <?php include "template/parts/games.php" ?>
                </div>
            </div>
        </div>
        </div>
    </main>
    <div class="seo-container">
        <div class="seo">
                <?php include "template/parts/articel.php"?>
        </div>
    </div>
    <?php include "template/parts/footer.php"?>
</body>
</html>